DROP PROCEDURE [hips].[PatientMasterIhiGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew Jacks
-- Description:   Gets a specific record or multiple records from the
--                PatientMasterIhi table.
-- Create date:   18 April 2012
-- Modified:
-- 30 Jul 2012 - Andrew Jacks - Added additional fields
-- 19 Dec 2012 - Simon Biber  - Removed PcehrAdvertised
-- 27 Jun 2013 - Simon Biber  - Added ability to get by IHI Status.
--                              Removed date of birth return because it
--                              doesn't take into account overrides.
-- =============================================
CREATE PROCEDURE [hips].[PatientMasterIhiGet] 
(
	 @PatientMasterId INT = NULL
	,@IhiStatusId INT = NULL
)
AS
BEGIN
	SELECT	  p.[PatientMasterId]
			, p.[Ihi]
			, p.[IhiStatusId]
			, p.[IhiRecordStatusId]
			, p.[RegisteredFamilyName]
			, p.[RegisteredGivenName]
			, p.[RegisteredSexId]
			, p.[DateLastValidated]
			, p.[DateCreated]
			, p.[UserCreated]
			, p.[DateModified]
			, p.[UserModified]
	FROM	hips.PatientMasterIhi p
	WHERE	(@PatientMasterId IS NULL OR p.PatientMasterId = @PatientMasterId)
	AND		(@IhiStatusId IS NULL OR p.IhiStatusId = @IhiStatusId)
END
GO

